<?php
if (!defined('ABSPATH')) {
  exit; // Exit if accessed directly.
}

class Ultimate_AI_Dashboard
{
  private $UAI_ORDERS, $USER_MANAGER, $UAI_ACTIVITIES;
  public function __construct()
  {
    add_action('wp_ajax_ultimate_ai_get_orders', [$this, 'get_orders']);
    add_action('wp_ajax_ultimate_ai_update_order', [$this, 'update_order']);
    add_action('wp_ajax_ultimate_ai_delete_order', [$this, 'ultimate_ai_delete_order']);
    add_action('wp_ajax_ultimate_ai_get_real_time_data', [$this, 'real_time_data']);
    add_action('wp_ajax_ultimate_ai_get_user_data', [$this, 'user_data']);
    add_action('wp_ajax_ultimate_ai_analytics_data', [$this, 'ultimate_ai_analytics_data']);
    add_action('wp_ajax_ultimate_ai_analytics_data_year', [$this, 'ultimate_ai_analytics_data_year']);
    add_action('wp_ajax_ultimate_ai_content_generation_graph', [$this, 'content_generation_data']);
    add_action('wp_ajax_ultimate_ai_get_activities', [$this, 'ultimate_ai_get_activities']);
    add_action('wp_ajax_ultimate_ai_user_generation_details', [$this, 'ultimate_ai_user_generation_details']);
    add_action('wp_ajax_ultimate_ai_all_users_generation_details', [$this, 'ultimate_ai_all_users_generation_details']);
    add_action('wp_ajax_ultimate_ai_user_generation_details_year', [$this, 'ultimate_ai_user_generation_details_year']);

    add_action('wp_ajax_ultimate_ai_TEST_DATA', [$this, 'ultimate_ai_TEST_DATA']);

    $this->UAI_ORDERS = new Ultimate_AI_Orders();
    $this->USER_MANAGER = new Ultimate_AI_User_Manager();
    $this->UAI_ACTIVITIES = new Ultimate_AI_Activity();
  }
  public function ultimate_ai_TEST_DATA()
  {
    $res = $this->USER_MANAGER->is_user_unlimited('word');
    wp_send_json($res, 200);

    $author_id = 1;
    $start_date = date('Y-m-01', strtotime('-1 month'));
    $end_date = date('Y-m-t', strtotime('now'));
    global $wpdb;

    $res = $wpdb->get_results(
      "SELECT
                DATE(p.post_date) AS date,
                tool_type.meta_value AS tool_type,
                SUM(token.meta_value) AS total
            FROM " . $wpdb->prefix . "posts AS p
            INNER JOIN " . $wpdb->prefix . "postmeta AS tool_type 
                ON p.ID = tool_type.post_id AND tool_type.meta_key = 'tool_type'
            LEFT JOIN " . $wpdb->prefix . "postmeta AS token
                ON p.ID = token.post_id AND token.meta_key = 'token'  
            WHERE 
                p.post_type IN ('ultimate_ai_history')
                AND (p.post_date BETWEEN '$start_date' AND '$end_date')
            GROUP BY
                DATE(p.post_date), tool_type
        "
    );

    wp_send_json($res, 200);
  }
  public function ultimate_ai_delete_order()
  {
    restrict_req_for_admin();
    $order_ids = Ultimate_AI_Filter_Controller($_POST['selectedOrders']);
    $limit = Ultimate_AI_Filter_Controller($_POST['limit']);
    $offset = Ultimate_AI_Filter_Controller($_POST['offset']);

    $res = $this->UAI_ORDERS->deleteOrders($order_ids, $limit, $offset);

    wp_send_json($res, 200);
  }
  public function update_order()
  {
    restrict_req_for_admin();
    $status = Ultimate_AI_Filter_Controller($_POST['status']);
    $order_id = Ultimate_AI_Filter_Controller($_POST['id']);

    $order = $this->UAI_ORDERS->updateOrderStatus($status, $order_id);
    $user = $this->USER_MANAGER->updateUserStatus($status, $order_id);

    wp_send_json([$order, $user], 200);
  }
  public function ultimate_ai_get_activities()
  {
    $limit = Ultimate_AI_Filter_Controller($_POST['limit']);
    $offset = Ultimate_AI_Filter_Controller($_POST['offset']);
    $activities = $this->UAI_ACTIVITIES->get_latest_activities($limit, $offset);
    wp_send_json($activities, 200);
  }

  public function ultimate_ai_analytics_data()
  {
    if (!is_user_logged_in()) {
      wp_send_json(false, 200);
    }
    $res = $this->UAI_ORDERS->UltimateAiEntryRecords();
    wp_send_json($res, 200);
  }

  public function ultimate_ai_analytics_data_year()
  {
    if (!is_user_logged_in()) {
      wp_send_json(false, 200);
    }
    $res = $this->UAI_ORDERS->UltimateAiEntryRecordsYearly();
    wp_send_json($res, 200);
  }

  public function user_data()
  {
    $res = $this->UAI_ORDERS->UltimateAiUsersData();
    wp_send_json($res, 200);
  }

  public function real_time_data()
  {
    $rtd = $this->UAI_ORDERS->UltimateAiAbstractGenerationDetails();
    wp_send_json($rtd, 200);
  }

  public function ultimate_ai_user_generation_details()
  {
    if (!is_user_logged_in()) {
      wp_send_json(false, 200);
    };
    $res = $this->UAI_ORDERS->generationDetailsUser();
    wp_send_json($res, 200);
  }

  public function ultimate_ai_all_users_generation_details()
  {
    if (!is_user_logged_in()) {
      wp_send_json(false, 200);
    };
    $res = $this->UAI_ORDERS->generationDetailsAllUsers();
    wp_send_json($res, 200);
  }

  public function ultimate_ai_user_generation_details_year()
  {
    if (!is_user_logged_in()) {
      wp_send_json(false, 200);
    };
    $res = $this->UAI_ORDERS->generationDetailsUserYear();
    wp_send_json($res, 200);
  }
  // CONTENT GENERATION DATA
  public function content_generation_data()
  {
    $res = $this->UAI_ORDERS->generationDetailsGraphData();
    wp_send_json($res, 200);
  }

  // GET ALL ORDERS
  public function get_orders()
  {
    $args = [];

    foreach ($_POST as $k => $data) {
      if (!empty($data)) {
        $args[$k] = $data;
      }
    }

    $orders = $this->UAI_ORDERS->filterOrders($args);
    wp_send_json($orders, 200);
  }
}
new Ultimate_AI_Dashboard();

